#!/usr/bin/env python3

import sys
import os
import json

_basepath = os.path.expanduser('~/www/suum/')
_jsonpath = '{}/{}'.format(_basepath, 'json/general.json')

def update_general_info(inc=None):
    if inc is None:
        number = len(os.listdir('{}/img/'.format(_basepath)))
    else:
        try:
            with open(_jsonpath) as f:
                number = json.load(f)['number']
        except Exception:
            number = 0
        number += inc

    info = {'number': number}
    with open(_jsonpath, 'w') as f:
        json.dump(info, f)

if __name__ == '__main__':
    update_general_info(*map(int, sys.argv[1:]))
