#!/usr/bin/env python3

import sys
import os
import shutil
import re
import tempfile
import zipfile

def convert_ora_to_png_simple(file_in, file_out=None):
    """
    convert_ora_to_png_simple(file_in : str, file_out : str =
    file_in(-ora)png)

    Convert an OpenRaster file to a PNG file. No support for opacity
    or more than one layer (the first non-background layer will
    automatically be picked).
    """

    if os.path.exists(file_out):
        raise Exception('out file already exists')

    temp_path = tempfile.mkdtemp()
    zf = zipfile.ZipFile(file_in)
    zf.extractall(temp_path)
    del zf
    with open('{}/stack.xml'.format(temp_path)) as f:
        xml = f.read()
    files = sorted(filter(lambda x: not x.endswith('background.png'),
                          ('{}/{}'.format(temp_path, x.strip('"\''))
                           for x in re.findall(r'src=(.+?.png)', xml))))
    fn = files[0]
    shutil.copy2(fn, os.path.abspath(file_out))

if __name__ == '__main__':
    convert_ora_to_png_simple(*sys.argv[1:])
