#!/bin/bash

# Add a new SUUM strip.
orig_ora="$PWD/$1"
if [ ! "$orig_ora" ]; then exit 1; fi

pushd "$HOME/www/suum/" > /dev/null

num=$((`ls -1 img/*.png | wc -l`+1))

. scripts/pngpaths
./scripts/pngize.sh "$orig_ora" &

echo -n 'Title: '
read title

false
while [ "$?" != "0" ]; do
    echo -n 'Name: '
    read name
    ./scripts/check_name.py "$name"
done

echo -n 'Comment: '
read comment

id="$num"_"$name"

# Wait until the PNGs have been created.
b64path="`echo "$orig_ora" | base64`"

false
while [ $? != 0 ]; do
    sleep .1
    cat "$b64path" 2>/dev/null
done
rm "$b64path"

mv "$orig_ora" "ora/$id.ora"
mv "$large" "png/$id.png"
mv "$medium" "img/$id.png"

./scripts/update_gen_info.py 1
./scripts/update_htaccess.py $num
./scripts/json_html_new.py "$title" $num "$name" "$comment" `date +%s`
./scripts/html_gen.py $(($num-1))
./scripts/html_archive_gen.py
./scripts/feed_gen.py

./scripts/upload_ssh.sh

