#!/usr/bin/env python3

import sys
import os
import datetime
import json

import html_gen

_basepath = html_gen._basepath

class NewJSONHTMLGenerator(html_gen.HTMLGenerator):
    def __init__(self, title, num, name, comment, timestamp):
        self.title = title
        self.number = int(num)
        self.name = name
        self.comment = comment
        self.timestamp = int(timestamp)
        self.generate_extra()

    def generate_json(self, out=sys.stdout):
        info = json.dumps({
                'title': self.title,
                'name': self.name,
                'number': self.number,
                'id': self.id,
                'timestamp': self.timestamp,
                'comment': self.comment
                })
        return info

if __name__ == '__main__':
    g = NewJSONHTMLGenerator(*sys.argv[1:])
    with open('{}/json/{}.json'.format(_basepath, g.number), 'w') as f:
        f.write(g.generate_json())
    with open('{}/_html/{}.html'.format(_basepath, g.number), 'w') as f:
        f.write(g.generate_html())
