#!/usr/bin/env python3

import sys
import os
import datetime
import json
from xml.sax.saxutils import quoteattr
import cgi

_basepath = os.path.expanduser('~/www/suum/')
try:
    with open('{}/{}'.format(_basepath, 'json/general.json')) as f:
        _gen_info = json.load(f)
except Exception:
    _gen_info = {'number': 0}
with open('{}/{}'.format(_basepath, 'static/template.html')) as f:
    _template = f.read()
with open('{}/{}'.format(_basepath, 'static/template_comic_body.html')) as f:
    _template_comic_body = f.read()
with open('{}/{}'.format(_basepath, 'static/template_comic_head.html')) as f:
    _template_comic_head = f.read()

class HTMLGenerator:
    def __init__(self, number):
        if number < 1:
            sys.exit()
        self.number = number
        with open('{}/json/{}.json'.format(_basepath, self.number)) as f:
            info = json.load(f)
        self.title = info['title']
        self.name = info['name']
        self.comment = info['comment']
        self.timestamp = info['timestamp']
        self.generate_extra()

    def generate_extra(self):
        self.id = '{}_{}'.format(self.number, self.name)
        self.date = datetime.datetime.utcfromtimestamp(self.timestamp)
        self.date_str = self.date.strftime('%Y-%m-%d %H:%M:%S UTC')

    def generate_html(self):
        if self.number > 1:
            prev_url = '/{}/'.format(self.number - 1)
        else:
            prev_url = '#'
        first = '/1/'

        if self.number < _gen_info['number']:
            next_url = '/{}/'.format(self.number + 1)
        else:
            next_url = '#'

        prev_link = "<link rel='prev' \
title='Previous comic' href='{}' />".format(prev_url)
        next_link = "<link rel='next' \
title='Next comic' href='{}' />".format(next_url)
        head = _template_comic_head.format(prev_link=prev_link,
                                           next_link=next_link)
        body = _template_comic_body.format(
            first=first, prev=prev_url, next=next_url, newest='/',
            id=self.id, comment=cgi.escape(self.comment),
            commentq=quoteattr(self.comment), number=self.number,
            date=self.date_str, title=self.title)
        html = _template.format(head=head, title=self.title, body=body)

        return html

if __name__ == '__main__':
    g = HTMLGenerator(*map(int, sys.argv[1:]))
    with open('{}/_html/{}.html'.format(_basepath, g.number), 'w') as f:
        f.write(g.generate_html())
