#!/usr/bin/env python3

import sys
import os
import json

import html_gen

def generate_extra_html(name):
    head = ''
    with open('{}/pages/{}.html'.format(html_gen._basepath, name)) as f:
        body = f.read()
    with open('{}/pages/{}.json'.format(html_gen._basepath, name)) as f:
        info = json.load(f)
    html = html_gen._template.format(head=head, title=info['title'], body=body)
    return html

if __name__ == '__main__':
    name = sys.argv[1]
    with open('{}/_html/{}.html'.format(html_gen._basepath, name), 'w') as f:
        f.write(generate_extra_html(name))
