#!/usr/bin/env python3

import sys
import os
import json
import re
import datetime

import html_gen

def generate_archive_html():
    head = ''

    col_str = "<tr><td>{number}</td><td>{date}</td><td><a href='/{number}/'>{title}</a></td></tr>"
    body = '<table><tr><th>#</th><th>Date</th><th>Title</th></tr>'
    for x in sorted(filter(lambda x: re.search(r'^\d+\.json$', x),
                           os.listdir('{}/json/'.format(
                    html_gen._basepath))), reverse=True,
                    key=lambda x: int(x[:x.find('.')])):
        with open('{}/json/{}'.format(html_gen._basepath, x)) as f:
            info = json.load(f)
            date_str = datetime.datetime.utcfromtimestamp(
                info['timestamp']).strftime('%Y-%m-%d %H:%M:%S UTC')
            body += col_str.format(number=info['number'], date=date_str,
                                   title=info['title'])
    body += '</table>'
    html = html_gen._template.format(head=head, title='Archive', body=body)
    return html

if __name__ == '__main__':
    with open('{}/_html/archive.html'.format(html_gen._basepath), 'w') as f:
        f.write(generate_archive_html())
