#!/usr/bin/env python3

import sys
import os
import json
import re
import datetime
from xml.sax.saxutils import quoteattr

import html_gen

# You need to change this if you're not running SUUM and you're not Niels.
root = 'http://suum.metanohi.name/'
_template = '''\
<?xml version="1.0" encoding="utf-8"?>
<feed xmlns='http://www.w3.org/2005/Atom' xml:lang='en'>

  <title>SUUM</title>
  <link href='{root}' rel='alternate' />
  <link href='{root}/atom.xml' rel='self' />
  <updated>{{updated}}</updated>
  <id>http://suum.metanohi.name/</id>

  <author>
    <name>Niels G. W. Serup</name>
    <email>ngws@metanohi.name</email>
    <uri>{root}about/niels</uri>
  </author>

  <rights>
  To the extent possible under law, Niels G. W. Serup has waived all copyright
  and related or neighboring rights to this feed. Feed content is available
  under the Creative Commons Zero 1.0 license, see
  http://creativecommons.org/publicdomain/zero/1.0/
  </rights>

  <subtitle>SUUM is a webcomic in the style of banal naivism.</subtitle>
  <generator uri='{root}static/suum-scripts.zip'>suum-scripts</generator>
  <icon>{root}static/feedicon.png</icon>
  <logo>{root}static/feedlogo.png</logo>

{{entries}}</feed>
'''.format(root=root)

_entry_template = '''\
  <entry>
    <title>{title}</title>
    <link href='{url}' />
    <id>{id}</id>
    <updated>{updated}</updated>
    <summary type='html'>{summary}</summary>
  </entry>

'''

def generate_feed():
    xml = _template
    entries = []
    for x in sorted(filter(lambda x: re.search(r'^\d+\.json$', x),
                           os.listdir('{}/json/'.format(
                    html_gen._basepath))),
                    key=lambda x: int(x[:x.find('.')]))[-4:]:
        with open('{}/json/{}'.format(html_gen._basepath, x)) as f:
            info = json.load(f)
            upd = datetime.datetime.utcfromtimestamp(
                info['timestamp']).strftime('%Y-%m-%dT%H:%M:%SZ')
            entries.append(_entry_template.format(
                title='{}: {}'.format(info['number'], info['title']),
                url = root + '{}/'.format(info['number']), id=info['number'],
                updated=upd,
                summary='''\
&lt;img src='{png}' title={comment} alt={comment} /&gt;'''.format(
                        comment=quoteattr(info['comment']),
                        png=root + 'img/' + info['id'] + '.png')))
    xml = xml.format(entries=''.join(entries[::-1]), updated=upd)
    return xml

if __name__ == '__main__':
    with open('{}/atom.xml'.format(html_gen._basepath), 'w') as f:
        f.write(generate_feed())
