#!/usr/bin/env python3

import sys

def contains_only_ascii(string):
    try:
        string.encode('ascii')
        return True
    except UnicodeEncodeError:
        return False

def has_space(string):
    return ' ' in string

def check_name(*strs):
    string = ' '.join(strs)
    if has_space(string) or not contains_only_ascii(string):
        return 1
    else:
        return 0

if __name__ == '__main__':
    sys.exit(check_name(*sys.argv[1:]))
